<?php

namespace App\Models\GestionSiteBusiness;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;
	protected $fillable = array('partenaire_id', 'libelle', 'adresse', 'gerant', 'statut');

	public function partenaire()
	{
		return $this->belongsTo('App\Models\GestionPartenaire\Partenaire');
	}

	public function guichets()
	{
		return $this->hasMany('App\Models\GestionSiteBusiness\Guichet', 'site_id');
	}

}