<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'name', 'email', 'date_of_birth');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function setting()
    {
        return $this->hasOne('Setting');
    }

    public function clientNotification()
    {
        return $this->belongsTo('App/Models\ClientNotification');
    }

    public function clientPosts()
    {
        return $this->belongsTo('App/Models\ClientPost');
    }

    public function bloodTypeClient()
    {
        return $this->belongsTo('App/Models\BloodTypeClient');
    }

}