<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_address', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('cart')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('order_id')->references('orderby_id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_address', function(Blueprint $table) {
			$table->dropForeign('user_address_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_cart_id_foreign');
		});
		Schema::table('payment_history', function(Blueprint $table) {
			$table->dropForeign('payment_history_user_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_user_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_order_id_foreign');
		});
	}
}