<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('gender', 10);
			$table->date('date_of_birth');
			$table->float('height');
			$table->float('current_weight');
			$table->float('goal_weight');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}