<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatingsTable extends Migration {

	public function up()
	{
		Schema::create('ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('score', array('1', '2', '3', '4', '5'));
			$table->text('body');
			$table->bigInteger('ratingable_id')->unsigned();
			$table->string('ratingable_type');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ratings');
	}
}