<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('offer_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->string('icon')->nullable();
			$table->string('description')->nullable();
			$table->integer('order');
			$table->boolean('active');
		});
	}

	public function down()
	{
		Schema::drop('offer_categories');
	}
}