<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTransactionMasterTable extends Migration {

	public function up()
	{
		Schema::create('offer_transaction_master', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('offer_type')->nullable();
			$table->string('title', 255)->nullable();
			$table->text('description')->nullable();
			$table->double('price', 8,2)->nullable();
			$table->integer('order_by')->nullable();
			$table->boolean('status')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offer_transaction_master');
	}
}