<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('Offer', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('house_id')->nullable();
			$table->integer('initiator_id');
			$table->integer('on_behalf_of');
			$table->integer('submitted_by');
			$table->boolean('status');
			$table->integer('parent_id');
			$table->integer('buyer_type');
			$table->string('offer_contract_assistance');
			$table->integer('offer_contract');
			$table->integer('latest_offer');
			$table->string('payment_type', 4);
			$table->string('settlement_agent_assigned');
			$table->string('settlement_agent_legal_name');
			$table->string('settlement_agent_email');
			$table->string('settlement_agent_number')->nullable();
			$table->string('settlement_agent_firm_name')->nullable();
			$table->string('settlement_agent_licence')->nullable();
			$table->string('settlement_agent_state')->nullable();
			$table->string('buyer_agent_assigned')->nullable();
			$table->string('buyer_agent_legal_name')->nullable();
			$table->string('buyer_agent_email')->nullable();
			$table->string('buyer_agent_number')->nullable();
			$table->string('buyer_agent_firm_name')->nullable();
			$table->string('buyer_agent_liscense')->nullable();
			$table->string('buyer_agent_state')->nullable();
			$table->integer('counter_by_type');
			$table->text('offer_comment');
			$table->datetime('counter_by_at');
			$table->integer('counter_by');
			$table->integer('is_summarise')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Offer');
	}
}