<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Link extends Model 
{

    protected $table = 'links';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'theme_id', 'user_id', 'link');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function theme()
    {
        return $this->belongsTo('Theme');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

}