<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class YearSubject extends Model 
{

    protected $table = 'year_subjects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function themes()
    {
        return $this->hasMany('Theme');
    }

    public function categories()
    {
        return $this->hasMany('Category');
    }

}