<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('holder_id', 'name');

    public function holder()
    {
        return $this->belongsTo('User', 'holder_id');
    }

    public function members()
    {
        return $this->belongsToMany('User');
    }

    public function homeworks()
    {
        return $this->belongsTo('Homework');
    }

}