<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Homework extends Model 
{

    protected $table = 'homeworks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('group_id');

    public function exercises()
    {
        return $this->belongsToMany('Exercise');
    }

    public function group()
    {
        return $this->hasOne('Group');
    }

    public function studentWorks()
    {
        return $this->hasMany('Studentwork');
    }

}