<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'year_subject_id');

	public function yearSubject()
	{
		return $this->belongsTo('YearSubject');
	}

	public function links()
	{
		return $this->hasMany('Link');
	}

}