<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('holder_id', 'name');

	public function holder()
	{
		return $this->belongsTo('User', 'holder_id');
	}

	public function members()
	{
		return $this->belongsToMany('User');
	}

	public function homeworks()
	{
		return $this->belongsTo('Homework');
	}

}