<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Link extends Eloquent {

	protected $table = 'links';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'theme_id', 'user_id', 'link');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function theme()
	{
		return $this->belongsTo('Theme');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

}