<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Theme extends Eloquent {

	protected $table = 'themes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'year_subject_id');

	public function exercises()
	{
		return $this->belongsTo('Exercise');
	}

	public function yearSubject()
	{
		return $this->belongsTo('YearSubject');
	}

	public function links()
	{
		return $this->hasMany('Link');
	}

}