<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Exercise extends Eloquent {

	protected $table = 'exercises';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('theme_id', 'type_id', 'user_id', 'name', 'source', 'statement');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function theme()
	{
		return $this->hasOne('Theme');
	}

	public function homeworks()
	{
		return $this->belongsToMany('Homework');
	}

	public function medias()
	{
		return $this->belongsToMany('Media');
	}

}