<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Homework extends Eloquent {

	protected $table = 'homeworks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('group_id');

	public function exercises()
	{
		return $this->belongsToMany('Exercise');
	}

	public function group()
	{
		return $this->hasOne('Group');
	}

	public function studentWorks()
	{
		return $this->hasMany('Studentwork');
	}

}