<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('media_tag', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('media_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tag')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('media_tag', function(Blueprint $table) {
			$table->dropForeign('media_tag_media_id_foreign');
		});
		Schema::table('media_tag', function(Blueprint $table) {
			$table->dropForeign('media_tag_tag_id_foreign');
		});
	}
}