<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projet', function(Blueprint $table) {
			$table->foreign('id_maitre_doeuvre')->references('id_maitre_doeuvre')->on('maitre_doeuvre')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->foreign('id_user')->references('id_user')->on('utilisateur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->foreign('id_maitre_douvrage')->references('id_maitre_douvrage')->on('maitre_d_ouvrage')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->foreign('id_mission_decontrole')->references('id_mission_decontrole')->on('mission_de_controle')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('etat_davancement', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_Projet')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lot', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_Projet')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('probleme', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_Projet')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recommandation', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_Projet')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ordre_de_service', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_Projet')->on('projet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appartient', function(Blueprint $table) {
			$table->foreign('id_group')->references('id_group')->on('groupe')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appartient', function(Blueprint $table) {
			$table->foreign('id_user')->references('id_user')->on('utilisateur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('avoir', function(Blueprint $table) {
			$table->foreign('id_droit')->references('id_droit')->on('droit')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('realise', function(Blueprint $table) {
			$table->foreign('id_Projet')->references('id_group')->on('groupe')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('realise', function(Blueprint $table) {
			$table->foreign('id_prestataire')->references('id_prestataire')->on('prestataire')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projet', function(Blueprint $table) {
			$table->dropForeign('projet_id_maitre_doeuvre_foreign');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->dropForeign('projet_id_user_foreign');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->dropForeign('projet_id_maitre_douvrage_foreign');
		});
		Schema::table('projet', function(Blueprint $table) {
			$table->dropForeign('projet_id_mission_decontrole_foreign');
		});
		Schema::table('etat_davancement', function(Blueprint $table) {
			$table->dropForeign('etat_davancement_id_Projet_foreign');
		});
		Schema::table('lot', function(Blueprint $table) {
			$table->dropForeign('lot_id_Projet_foreign');
		});
		Schema::table('probleme', function(Blueprint $table) {
			$table->dropForeign('probleme_id_Projet_foreign');
		});
		Schema::table('recommandation', function(Blueprint $table) {
			$table->dropForeign('recommandation_id_Projet_foreign');
		});
		Schema::table('ordre_de_service', function(Blueprint $table) {
			$table->dropForeign('ordre_de_service_id_Projet_foreign');
		});
		Schema::table('appartient', function(Blueprint $table) {
			$table->dropForeign('appartient_id_group_foreign');
		});
		Schema::table('appartient', function(Blueprint $table) {
			$table->dropForeign('appartient_id_user_foreign');
		});
		Schema::table('avoir', function(Blueprint $table) {
			$table->dropForeign('avoir_id_droit_foreign');
		});
		Schema::table('realise', function(Blueprint $table) {
			$table->dropForeign('realise_id_Projet_foreign');
		});
		Schema::table('realise', function(Blueprint $table) {
			$table->dropForeign('realise_id_prestataire_foreign');
		});
	}
}