<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjetTable extends Migration {

	public function up()
	{
		Schema::create('projet', function(Blueprint $table) {
			$table->increments('id_Projet');
			$table->timestamps();
			$table->string('nom')->unique();
			$table->string('type')->unique();
			$table->string('etat_projet')->unique();
			$table->timestamps();
			$table->date('date_debut')->unique();
			$table->date('date_fin');
			$table->date('date_cloture')->unique();
			$table->float('budget')->unique();
			$table->integer('id_maitre_doeuvre')->unique()->unsigned();
			$table->integer('id_user')->unique()->unsigned();
			$table->integer('id_maitre_douvrage')->unique()->unsigned();
			$table->integer('id_mission_decontrole')->unique()->unsigned();
			$table->date('delai_execution');
			$table->integer('budget_prestataire');
			$table->integer('budget_maitre_d_oeuvre');
		});
	}

	public function down()
	{
		Schema::drop('projet');
	}
}