<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVentesTable extends Migration {

	public function up()
	{
		Schema::create('ventes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('montant_total');
			$table->integer('nbre_articles');
			$table->integer('id_client')->unsigned();
			$table->float('reduction')->nullable();
			$table->float('tva')->nullable();
			$table->float('prix_ttc');
			$table->string('devise', 255)->nullable();
			$table->string('moyen_de_payement', 255)->nullable();
			$table->string('source_vente', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ventes');
	}
}