<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAvailabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('availabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('start');
			$table->datetime('end');
			$table->boolean('repeat');
			$table->tinyInteger('repeat_every');
			$table->enum('repeat_type', array('day', 'weekday', 'week', 'month', 'year'));
			$table->date('repeat_until');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('availabilities');
	}
}