<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AvailabilityCalendar extends Eloquent {

	protected $table = 'availability_calendars';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Availability()
	{
		return $this->hasMany('Availability', 'id');
	}

	public function Calendar()
	{
		return $this->hasMany('Calendar', 'id');
	}

}