<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Company()
	{
		return $this->hasOne('Company', 'id');
	}

	public function User()
	{
		return $this->hasOne('User', 'id');
	}

}