<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserLocation extends Eloquent {

	protected $table = 'user_locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function User()
	{
		return $this->hasMany('User', 'id');
	}

	public function Location()
	{
		return $this->hasOne('Location', 'id');
	}

}