<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserLocation extends Model 
{

    protected $table = 'user_locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function User()
    {
        return $this->hasMany('User', 'id');
    }

    public function Location()
    {
        return $this->hasOne('Location', 'id');
    }

}