<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserService extends Model 
{

    protected $table = 'user_services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function User()
    {
        return $this->hasMany('User', 'id');
    }

    public function Service()
    {
        return $this->hasOne('Service', 'id');
    }

}