<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('domains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_locations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_locations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('availability_services', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('availability_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('domains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('availability_repeat_breaks', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file_documents', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file_documents', function(Blueprint $table) {
			$table->foreign('by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file_notes', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('file_notes', function(Blueprint $table) {
			$table->foreign('by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_items', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('app_modules', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_app_modules', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_app_modules', function(Blueprint $table) {
			$table->foreign('app_module_id')->references('id')->on('app_modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('availability_calendars', function(Blueprint $table) {
			$table->foreign('availability_id')->references('id')->on('availabilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('availability_calendars', function(Blueprint $table) {
			$table->foreign('calendar_id')->references('id')->on('calendars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_domain_id_foreign');
		});
		Schema::table('user_locations', function(Blueprint $table) {
			$table->dropForeign('user_locations_user_id_foreign');
		});
		Schema::table('user_locations', function(Blueprint $table) {
			$table->dropForeign('user_locations_location_id_foreign');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->dropForeign('user_services_user_id_foreign');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->dropForeign('user_services_service_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_user_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_company_id_foreign');
		});
		Schema::table('availability_services', function(Blueprint $table) {
			$table->dropForeign('availability_services_availability_id_foreign');
		});
		Schema::table('availability_services', function(Blueprint $table) {
			$table->dropForeign('availability_services_service_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_domain_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_parent_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_availability_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_service_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_client_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_by_user_id_foreign');
		});
		Schema::table('availability_repeat_breaks', function(Blueprint $table) {
			$table->dropForeign('availability_repeat_breaks_availability_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_appointment_id_foreign');
		});
		Schema::table('file_documents', function(Blueprint $table) {
			$table->dropForeign('file_documents_file_id_foreign');
		});
		Schema::table('file_documents', function(Blueprint $table) {
			$table->dropForeign('file_documents_by_user_id_foreign');
		});
		Schema::table('file_notes', function(Blueprint $table) {
			$table->dropForeign('file_notes_file_id_foreign');
		});
		Schema::table('file_notes', function(Blueprint $table) {
			$table->dropForeign('file_notes_by_user_id_foreign');
		});
		Schema::table('group_items', function(Blueprint $table) {
			$table->dropForeign('group_items_group_id_foreign');
		});
		Schema::table('app_modules', function(Blueprint $table) {
			$table->dropForeign('app_modules_app_id_foreign');
		});
		Schema::table('role_app_modules', function(Blueprint $table) {
			$table->dropForeign('role_app_modules_role_id_foreign');
		});
		Schema::table('role_app_modules', function(Blueprint $table) {
			$table->dropForeign('role_app_modules_app_module_id_foreign');
		});
		Schema::table('availability_calendars', function(Blueprint $table) {
			$table->dropForeign('availability_calendars_availability_id_foreign');
		});
		Schema::table('availability_calendars', function(Blueprint $table) {
			$table->dropForeign('availability_calendars_calendar_id_foreign');
		});
	}
}