<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('domain_id')->unsigned();
			$table->string('username')->unique();
			$table->string('password');
			$table->string('firstname');
			$table->string('prefix');
			$table->string('lastname');
			$table->enum('gender', array('m', 'f', 'u'));
			$table->string('email')->unique();
			$table->string('mobile');
			$table->enum('role', array('admin', 'partner', 'client', 'public'));
			$table->string('code');
			$table->enum('status', array('active', 'invited', 'notinvited', 'blocked'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}