<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('hosts', function(Blueprint $table) {
			$table->foreign('pool_id')->references('id')->on('pools')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hosts', function(Blueprint $table) {
			$table->foreign('datacenter_id')->references('id')->on('datacenters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('virtualmachines', function(Blueprint $table) {
			$table->foreign('host_id')->references('id')->on('hosts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('disks', function(Blueprint $table) {
			$table->foreign('vm_id')->references('id')->on('virtualmachines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->foreign('vm_id')->references('id')->on('virtualmachines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('virtualhosts', function(Blueprint $table) {
			$table->foreign('vm_id')->references('id')->on('virtualmachines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('virtualhosts', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alias', function(Blueprint $table) {
			$table->foreign('vh_id')->references('id')->on('virtualhosts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('software', function(Blueprint $table) {
			$table->foreign('vm_id')->references('id')->on('virtualmachines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pools', function(Blueprint $table) {
			$table->foreign('host_master_id')->references('id')->on('hosts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_customers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_customers', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts_services', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services_virtualmachines', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services_virtualmachines', function(Blueprint $table) {
			$table->foreign('vm_id')->references('id')->on('virtualmachines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('hosts', function(Blueprint $table) {
			$table->dropForeign('hosts_pool_id_foreign');
		});
		Schema::table('hosts', function(Blueprint $table) {
			$table->dropForeign('hosts_datacenter_id_foreign');
		});
		Schema::table('virtualmachines', function(Blueprint $table) {
			$table->dropForeign('virtualmachines_host_id_foreign');
		});
		Schema::table('disks', function(Blueprint $table) {
			$table->dropForeign('disks_vm_id_foreign');
		});
		Schema::table('networks', function(Blueprint $table) {
			$table->dropForeign('networks_vm_id_foreign');
		});
		Schema::table('virtualhosts', function(Blueprint $table) {
			$table->dropForeign('virtualhosts_vm_id_foreign');
		});
		Schema::table('virtualhosts', function(Blueprint $table) {
			$table->dropForeign('virtualhosts_agency_id_foreign');
		});
		Schema::table('alias', function(Blueprint $table) {
			$table->dropForeign('alias_vh_id_foreign');
		});
		Schema::table('software', function(Blueprint $table) {
			$table->dropForeign('software_vm_id_foreign');
		});
		Schema::table('pools', function(Blueprint $table) {
			$table->dropForeign('pools_host_master_id_foreign');
		});
		Schema::table('users_customers', function(Blueprint $table) {
			$table->dropForeign('users_customers_user_id_foreign');
		});
		Schema::table('users_customers', function(Blueprint $table) {
			$table->dropForeign('users_customers_customer_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_user_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_role_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_contract_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_customer_id_foreign');
		});
		Schema::table('contracts_services', function(Blueprint $table) {
			$table->dropForeign('contracts_services_contract_id_foreign');
		});
		Schema::table('contracts_services', function(Blueprint $table) {
			$table->dropForeign('contracts_services_service_id_foreign');
		});
		Schema::table('services_virtualmachines', function(Blueprint $table) {
			$table->dropForeign('services_virtualmachines_service_id_foreign');
		});
		Schema::table('services_virtualmachines', function(Blueprint $table) {
			$table->dropForeign('services_virtualmachines_vm_id_foreign');
		});
	}
}