<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJsonLogTable extends Migration {

	public function up()
	{
		Schema::create('json_log', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date')->index();
			$table->enum('type', array('host', 'pool', 'virtualmachine', 'virtualhost', 'software', 'customer'))->index();
			$table->string('filename');
			$table->tinyInteger('status')->unsigned();
			$table->string('message');
		});
	}

	public function down()
	{
		Schema::drop('json_log');
	}
}