<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->date('date_start')->index();
			$table->date('date_end')->index();
			$table->integer('customer_id')->unsigned();
			$table->integer('ram')->nullable();
			$table->integer('cpu')->nullable();
			$table->integer('file_system')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}