<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVirtualmachinesTable extends Migration {

	public function up()
	{
		Schema::create('virtualmachines', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamp_from');
			$table->timestamp('timestamp_to');
			$table->boolean('active')->index();
			$table->integer('host_id')->unsigned();
			$table->string('uname')->index();
			$table->string('name')->index();
			$table->string('distro');
			$table->integer('major');
			$table->integer('minor');
			$table->string('vm_name')->index();
			$table->string('name_description');
			$table->integer('uptime');
			$table->string('uuid', 36);
			$table->bigInteger('ram');
			$table->integer('cpu')->unsigned();
			$table->boolean('up_to_date');
			$table->string('resident_on');
			$table->string('scope')->default('frontend');
		});
	}

	public function down()
	{
		Schema::drop('virtualmachines');
	}
}