<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriasBlogTable extends Migration {

	public function up()
	{
		Schema::create('categorias_blog', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_padre')->unsigned()->nullable();
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->text('title_tc')->nullable();
			$table->text('title_og')->nullable();
			$table->text('description_tc')->nullable();
			$table->text('description_og')->nullable();
			$table->string('robots', 100);
			$table->text('h1')->nullable();
			$table->string('canonical', 255)->nullable();
			$table->text('nombre')->nullable();
			$table->mediumText('descripcion_corta')->nullable();
			$table->longText('descripcion_larga')->nullable();
			$table->integer('orden');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categorias_blog');
	}
}