<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_categorias_blog')->unsigned();
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->text('title_tc')->nullable();
			$table->text('title_og')->nullable();
			$table->text('description_tc')->nullable();
			$table->text('description_og')->nullable();
			$table->string('robots', 100);
			$table->text('h1')->nullable();
			$table->string('canonical', 255)->nullable();
			$table->text('nombre')->nullable();
			$table->longText('descripcion_larga')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->timestamp('fecha_publicacion');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}