<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reservation extends Model 
{

    protected $table = 'reservations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function student()
    {
        return $this->belongsTo('Student');
    }

    public function slot()
    {
        return $this->hasOne('Slot');
    }

    public function coach()
    {
        return $this->belongsTo('Coach');
    }

    public function participants()
    {
        return $this->hasMany('Reservation');
    }

    public function videos()
    {
        return $this->hasMany('MediaLibrary');
    }

}