<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('languageable', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('specializables', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('coaches', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('coaches', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('coach_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('coach_student', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('slots', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('students')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('slots', function(Blueprint $table) {
			$table->foreign('agenda_id')->references('id')->on('agendas')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('agendas', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('promo_codes', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_country_id_foreign');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('languageable', function(Blueprint $table) {
			$table->dropForeign('languageable_language_id_foreign');
		});
		Schema::table('specializables', function(Blueprint $table) {
			$table->dropForeign('specializables_specialty_id_foreign');
		});
		Schema::table('coaches', function(Blueprint $table) {
			$table->dropForeign('coaches_country_id_foreign');
		});
		Schema::table('coaches', function(Blueprint $table) {
			$table->dropForeign('coaches_city_id_foreign');
		});
		Schema::table('coach_student', function(Blueprint $table) {
			$table->dropForeign('coach_student_student_id_foreign');
		});
		Schema::table('coach_student', function(Blueprint $table) {
			$table->dropForeign('coach_student_coach_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_coach_id_foreign');
		});
		Schema::table('slots', function(Blueprint $table) {
			$table->dropForeign('slots_coach_id_foreign');
		});
		Schema::table('slots', function(Blueprint $table) {
			$table->dropForeign('slots_agenda_id_foreign');
		});
		Schema::table('agendas', function(Blueprint $table) {
			$table->dropForeign('agendas_coach_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_student_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_coach_id_foreign');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->dropForeign('participants_student_id_foreign');
		});
		Schema::table('promo_codes', function(Blueprint $table) {
			$table->dropForeign('promo_codes_coach_id_foreign');
		});
	}
}