<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function conversation()
	{
		return $this->belongsTo('Conversation');
	}

	public function sender()
	{
		return $this->morphTo();
	}

	public function recivier()
	{
		return $this->morphTo();
	}

}