<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id');

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function languages()
	{
		return $this->morphToMany('Language', 'languageable');
	}

	public function specialties()
	{
		return $this->morphToMany('Specialty', 'specializables')->withPivot('self_evaluation');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function golfAttribute()
	{
		return $this->morphOne('GolfAttribute', 'model');
	}

	public function favouriteCoaches()
	{
		return $this->belongsToMany('Coach', 'student_coach');
	}

	public function address()
	{
		return $this->morphOne('Address', 'model');
	}

	public function notifiationSettings()
	{
		return $this->morphMany('NotificationSettings');
	}

	public function videos()
	{
		return $this->hasMany('MediaLibrary');
	}

}