<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationSettingsTable extends Migration {

	public function up()
	{
		Schema::create('notification_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('model_type');
			$table->bigInteger('model_id')->index();
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('request_accepted_notifications')->default(true);
			$table->boolean('messages_notifications')->default(true);
			$table->boolean('new_evaluation_notifications')->default(true);
			$table->boolean('request_accepted_emails')->default(true);
			$table->boolean('messages_emails')->default(true);
			$table->boolean('new_evaluation_emails')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('notification_settings');
	}
}