<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('App\Group');
	}

	public function city()
	{
		return $this->belongsTo('App\City');
	}

}