<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned()->index();
			$table->datetime('due_date')->nullable();
			$table->datetime('order_date')->nullable();
			$table->integer('created_by')->unsigned();
			$table->string('slogan')->nullable();
			$table->string('footer')->nullable();
			$table->text('notes')->nullable();
			$table->integer('ticket_number')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}