<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('license')->nullable();
			$table->string('email')->nullable();
			$table->string('organization')->nullable();
			$table->tinyInteger('referred')->default('0');
			$table->string('contact_person')->nullable();
			$table->integer('customer_group_id')->unsigned();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->integer('network_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}