<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManageInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('manage_invoices', function(Blueprint $table) {
			$table->string('product_name')->nullable();
			$table->increments('id');
			$table->timestamps();
			$table->text('description')->nullable();
			$table->text('notes')->nullable();
			$table->integer('invoice_id')->unsigned()->index();
			$table->tinyInteger('quantity')->nullable();
			$table->integer('price')->nullable();
			$table->tinyInteger('line_discount')->nullable();
			$table->integer('taxclass')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('manage_invoices');
	}
}