<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessCaseTable extends Migration {

	public function up()
	{
		Schema::create('business_case', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_project')->unsigned();
			$table->string('file', 600);
			$table->bigInteger('it_investments');
			$table->bigInteger('it_costs');
			$table->bigInteger('other_non_it_costs');
			$table->bigInteger('costs_in_progress');
			$table->bigInteger('internal_it_days');
			$table->bigInteger('internal_non_it_days');
			$table->date('ex_post_approval_date');
			$table->integer('responsible_for_approval')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('business_case');
	}
}