<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWbsTable extends Migration {

	public function up()
	{
		Schema::create('wbs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_project')->unsigned();
			$table->string('name', 255);
			$table->text('short_descr');
			$table->integer('id_parent')->unsigned();
			$table->bigInteger('planned_effort');
			$table->bigInteger('final_effort');
			$table->bigInteger('material_cost_budget');
			$table->bigInteger('material_cost_actual');
			$table->bigInteger('internal_resource_cost_budget');
			$table->bigInteger('internal_resource_cost_actual');
			$table->bigInteger('external_resource_cost_budget');
			$table->string('external_resource_cost_actual');
			$table->integer('owner')->unsigned();
			$table->date('planned_start_date');
			$table->date('actual_start_date');
			$table->date('planned_final_date');
			$table->date('actual_closing_date');
			$table->boolean('milestone');
			$table->integer('actual_completion');
			$table->boolean('suspend_activity');
			$table->text('output_phrase');
			$table->string('link_to_repository', 600);
			$table->boolean('quick_creation');
		});
	}

	public function down()
	{
		Schema::drop('wbs');
	}
}