<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('client_id', 'address', 'special_order', 'notes', 'total_price', 'additional_cost', 'payment', 'status', 'commission');

    public function products()
    {
        return $this->belongsToMany('App\Product');
    }

    public function client()
    {
        return $this->belongsTo('App\Client');
    }

    public function restaurant()
    {
        return $this->belongsTo('App\Restaurant');
    }

}