<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTbSystemTable extends Migration {

	public function up()
	{
		Schema::create('tb_system', function(Blueprint $table) {
			$table->integer('system_id')->unique()->unsigned();
			$table->string('system_name', 255);
			$table->string('system_acronym', 20)->nullable();
			$table->text('system_description')->nullable();
			$table->string('system_default_url', 255);
			$table->datetime('system_dt_c');
			$table->datetime('system_dt_u')->nullable();
			$table->string('system_user_c', 50);
			$table->string('system_user_u', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tb_system');
	}
}