<?php

namespace App\Model;

class Covoiturage extends Eloquent {

	protected $table = 'covoiturages';
	public $timestamps = true;

	public function villeDepart()
	{
		return $this->belongsTo('App\Model\Ville', 'ville_depart_id');
	}

	public function villeArrivee()
	{
		return $this->belongsTo('App\Model\Ville', 'ville_arrivee_id');
	}

	public function inscrits()
	{
		return $this->belongsToMany('App\Model\User')->withPivot('user_covoiturage_preinscrits');
	}

	public function preinscrits()
	{
		return $this->belongsToMany('App\Model\User');
	}

	public function conducteur()
	{
		return $this->belongsTo('App\Model\User', 'conducteur_id');
	}

	public function commentaires()
	{
		return $this->hasMany('App\Model\Commentaire');
	}

}